/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import ht.treechop.client.Client;
import ht.treechop.client.gui.util.Sprite;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.settings.ChopSettings;
import ht.treechop.common.util.ChopUtil;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ChopIndicator
extends AbstractGui {
    private static final double IMAGE_SCALE = 1.0;
    private static BlockPos lastBlockPos = null;
    private static final ChopSettings lastChopSettings = new ChopSettings();
    private static boolean lastBlockWouldBeChopped = false;

    public void render(MainWindow window, MatrixStack matrixStack, float partialTicks) {
        Minecraft minecraft = Minecraft.func_71410_x();
        RayTraceResult mouseOver = minecraft.field_71476_x;
        if (Client.isChoppingIndicatorEnabled() && minecraft.field_71462_r == null && mouseOver != null && mouseOver.func_216346_c() == RayTraceResult.Type.BLOCK && mouseOver instanceof BlockRayTraceResult) {
            BlockPos blockPos = ((BlockRayTraceResult)mouseOver).func_216350_a();
            if (this.blockWouldBeChopped(blockPos)) {
                int windowWidth = window.func_198107_o();
                int windowHeight = window.func_198087_p();
                minecraft.func_110434_K().func_110577_a(Sprite.TEXTURE_PATH);
                int indicatorCenterX = windowWidth / 2 + (Integer)ConfigHandler.CLIENT.indicatorXOffset.get();
                int indicatorCenterY = windowHeight / 2 + (Integer)ConfigHandler.CLIENT.indicatorYOffset.get();
                Sprite sprite = ChopUtil.playerWantsToFell((PlayerEntity)minecraft.field_71439_g, Client.getChopSettings()) ? Sprite.CHOP_INDICATOR : Sprite.NO_FELL_INDICATOR;
                int imageWidth = (int)((double)sprite.width * 1.0);
                int imageHeight = (int)((double)sprite.height * 1.0);
                sprite.blit(matrixStack, indicatorCenterX - imageWidth / 2, indicatorCenterY - imageHeight / 2, imageWidth, imageHeight);
            }
            lastBlockPos = blockPos;
            lastChopSettings.copyFrom(Client.getChopSettings());
        } else {
            lastBlockPos = null;
        }
    }

    private boolean blockWouldBeChopped(BlockPos pos) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientPlayerEntity player = minecraft.field_71439_g;
        ClientWorld world = minecraft.field_71441_e;
        if (world != null & minecraft.field_71439_g != null && ChopUtil.canChopWithTool(player.func_184614_ca()) && ChopUtil.playerWantsToChop((PlayerEntity)minecraft.field_71439_g, Client.getChopSettings())) {
            if (pos.equals((Object)lastBlockPos) || !Client.getChopSettings().equals(lastChopSettings)) {
                lastBlockWouldBeChopped = ChopUtil.playerWantsToFell((PlayerEntity)player, Client.getChopSettings()) ? ChopUtil.isPartOfATree((World)world, pos, Client.getChopSettings().getTreesMustHaveLeaves()) : ChopUtil.isBlockALog((IWorld)world, pos);
            }
        } else {
            lastBlockWouldBeChopped = false;
        }
        return lastBlockWouldBeChopped;
    }
}

